create or replace package tbicds.PCK_INTAKE AUTHID CURRENT_USER is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/
  --custom to return recordsets
  type RetRefCursor is ref cursor;


 /*****
  Delete Instrument 
  *****/
  procedure DeleteInstrument(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP  in varchar2,
                             pi_nUserID           in number,
                                     
                             pi_vPatientID        in varchar2,
                             pi_nIntakeID         in number,
                             pi_nMID              in number,
                             pi_nPWEventModuleID  in number,
                                     
                             po_nStatusCode       out number,
                             po_vStatusComment    out varchar2);

/*get rs of modules that are scoreable*/

procedure GetAllScorableModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);
                             
  
  /*get module type*/
  procedure GetModuleType(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          po_nModuleType      out number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2);
                        
  /*get intake modules by group id*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  /*get intake modules by group id and perform an inner search*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                pi_vSearch          in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);
                                
  /*get module groups by group type id*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nGroupTypeID     in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  /*get module group types such as domain and clinical setting*/
  procedure GetModuleGroupTypeRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);

  procedure GetResponseLoadRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vLoadTable       in varchar2,
                              pi_vLoadField       in varchar2,
                              pi_vLoadFilter      in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor);

  procedure GetIntakeModulesRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor);

  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure GetModulesListRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure StartModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2);
                           
  -- *****************************************************
  -- MARK MODULE COMPLETE
  procedure CompleteModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2);

  -- *****************************************************
  -- INSERT ENCOUNTER INTAKE 
  

  -- *****************************************************
  -- Insert Encounter Intake Score


/*get rs of modules matching search criteria*/
procedure GetAllModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);
  

/*get rs of modules matching search criteria*/
procedure GetModuleSearchRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSearch          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);

PROCEDURE GetScoreDataStringRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);
                                      
procedure GetNextMIDIntakeIDRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP   in varchar2,
                             pi_nUserID            in number,
                             pi_vPatientID          in varchar2,
                             pi_nMID                in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) ;

end;
/

